/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.skinsrestorer.api.SkinVariant;
import net.skinsrestorer.api.SkinsRestorerAPI;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.interfaces.ISRCommandSender;
import net.skinsrestorer.api.interfaces.ISRPlayer;
import net.skinsrestorer.api.model.MojangProfileResponse;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.shadow.aikar.commands.CommandHelp;
import net.skinsrestorer.shared.commands.CommandUtil;
import net.skinsrestorer.shared.interfaces.ISRPlugin;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.utils.C;
import net.skinsrestorer.shared.utils.connections.ServiceChecker;

public interface ISRCommand {
    default public void onHelp(ISRCommandSender sender, CommandHelp help) {
        help.showHelp();
    }

    default public void reloadCustomHook() {
    }

    default public void onReload(ISRCommandSender sender) {
        if (!CommandUtil.isAllowedToExecute(sender)) {
            return;
        }
        ISRPlugin plugin = this.getPlugin();
        this.reloadCustomHook();
        Locale.load(plugin.getDataFolderPath(), plugin.getSrLogger());
        Config.load(plugin.getDataFolderPath(), plugin.getResource("config.yml"), plugin.getSrLogger());
        plugin.prepareACF(plugin.getManager(), plugin.getSrLogger());
        sender.sendMessage(Locale.RELOAD);
    }

    default public void onStatus(ISRCommandSender sender) {
        if (!CommandUtil.isAllowedToExecute(sender)) {
            return;
        }
        ISRPlugin plugin = this.getPlugin();
        plugin.runAsync(() -> {
            sender.sendMessage("\u00a77Checking needed services for SR to work properly...");
            LinkedList<String> statusMessages = new LinkedList<String>();
            String breakLine = "\u00a73----------------------------------------------";
            statusMessages.add(breakLine);
            ServiceChecker checker = new ServiceChecker();
            checker.setMojangAPI(plugin.getMojangAPI());
            checker.checkServices();
            ServiceChecker.ServiceCheckResponse response = checker.getResponse();
            List<String> results = response.getResults();
            int workingUUIDCount = response.getWorkingUUID().get();
            int workingProfileCount = response.getWorkingProfile().get();
            if (Config.DEBUG || workingUUIDCount == 0 || workingProfileCount == 0) {
                for (String result : results) {
                    if (!Config.DEBUG && !result.contains("\u2718")) continue;
                    statusMessages.add(result);
                }
            }
            statusMessages.add("\u00a77Working UUID API count: \u00a76" + workingUUIDCount);
            statusMessages.add("\u00a77Working Profile API count: \u00a76" + workingProfileCount);
            if (workingUUIDCount != 0 && workingProfileCount != 0) {
                statusMessages.add("\u00a7aThe plugin currently is in a working state.");
            } else {
                statusMessages.add("\u00a7cPlugin currently can't fetch new skins. \n Connection is likely blocked because of firewall. \n Please See http://skinsrestorer.net/firewall for more info");
            }
            statusMessages.add(breakLine);
            statusMessages.add("\u00a77SkinsRestorer \u00a76v" + plugin.getVersion());
            statusMessages.add("\u00a77Server: \u00a76" + this.getPlatformVersion());
            statusMessages.add("\u00a77ProxyMode: \u00a76" + this.getProxyMode());
            statusMessages.add("\u00a77Finished checking services.");
            statusMessages.add(breakLine);
            statusMessages.forEach(sender::sendMessage);
        });
    }

    default public void onDrop(ISRCommandSender sender, PlayerOrSkin playerOrSkin, String target) {
        if (!CommandUtil.isAllowedToExecute(sender)) {
            return;
        }
        ISRPlugin plugin = this.getPlugin();
        plugin.runAsync(() -> {
            switch (playerOrSkin) {
                case PLAYER: {
                    plugin.getSkinStorage().removeSkinOfPlayer(target);
                    break;
                }
                case SKIN: {
                    plugin.getSkinStorage().removeSkinData(target);
                }
            }
            sender.sendMessage(Locale.DATA_DROPPED.replace("%playerOrSkin", playerOrSkin.toString()).replace("%targets", target));
        });
    }

    default public void onProps(ISRCommandSender sender, ISRPlayer target) {
        if (!CommandUtil.isAllowedToExecute(sender)) {
            return;
        }
        ISRPlugin plugin = this.getPlugin();
        plugin.runAsync(() -> {
            try {
                List<IProperty> properties = this.getPropertiesOfPlayer(target);
                if (properties.isEmpty()) {
                    sender.sendMessage(Locale.NO_SKIN_DATA);
                    return;
                }
                IProperty prop = properties.get(0);
                String name = prop.getName();
                String value = prop.getValue();
                String signature = prop.getSignature();
                MojangProfileResponse profile = SkinsRestorerAPI.getApi().getSkinProfileData(prop);
                String decodedSkin = profile.getTextures().getSKIN().getUrl();
                long timestamp = profile.getTimestamp();
                String requestDate = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(timestamp));
                sender.sendMessage("\u00a7aRequest time: \u00a7e" + requestDate);
                sender.sendMessage("\u00a7aProfileId: \u00a7e" + profile.getProfileId());
                sender.sendMessage("\u00a7aName: \u00a7e" + profile.getProfileName());
                sender.sendMessage("\u00a7aSkinTexture: \u00a7e" + decodedSkin);
                sender.sendMessage("\u00a7cMore info in console!");
                plugin.getSrLogger().info("\u00a7aName: \u00a78" + name);
                plugin.getSrLogger().info("\u00a7aValue: \u00a78" + value);
                plugin.getSrLogger().info("\u00a7aSignature: \u00a78" + signature);
                plugin.getSrLogger().info("\u00a7aValue Decoded: \u00a7e" + profile);
            }
            catch (Exception e) {
                e.printStackTrace();
                sender.sendMessage(Locale.NO_SKIN_DATA);
            }
        });
    }

    default public void onApplySkin(ISRCommandSender sender, ISRPlayer target) {
        if (!CommandUtil.isAllowedToExecute(sender)) {
            return;
        }
        ISRPlugin plugin = this.getPlugin();
        plugin.runAsync(() -> {
            try {
                SkinsRestorerAPI.getApi().applySkin(target.getWrapper(), plugin.getSkinStorage().getDefaultSkinForPlayer(sender.getName()));
                sender.sendMessage(Locale.ADMIN_APPLYSKIN_SUCCES);
            }
            catch (Exception ignored) {
                sender.sendMessage(Locale.ADMIN_APPLYSKIN_ERROR);
            }
        });
    }

    default public void onCreateCustom(ISRCommandSender sender, String name, String skinUrl, SkinVariant skinVariant) {
        if (!CommandUtil.isAllowedToExecute(sender)) {
            return;
        }
        ISRPlugin plugin = this.getPlugin();
        plugin.runAsync(() -> {
            try {
                if (C.validUrl(skinUrl)) {
                    plugin.getSkinStorage().setSkinData(name, SkinsRestorerAPI.getApi().genSkinUrl(skinUrl, skinVariant), System.currentTimeMillis() + 3153600000000L);
                    sender.sendMessage(Locale.SUCCESS_CREATE_SKIN.replace("%skin", name));
                } else {
                    sender.sendMessage(Locale.ERROR_INVALID_URLSKIN);
                }
            }
            catch (SkinRequestException e) {
                sender.sendMessage(e.getMessage());
            }
        });
    }

    default public void onSetSkinAll(ISRCommandSender sender, String skin, SkinVariant skinVariant) {
        if (!CommandUtil.isAllowedToExecute(sender)) {
            return;
        }
        ISRPlugin plugin = this.getPlugin();
        plugin.runAsync(() -> {
            if (!sender.isConsole()) {
                sender.sendMessage(Locale.PREFIX + "\u00a74Only console may execute this command!");
                return;
            }
            String skinName = " \u00b7setSkinAll";
            try {
                IProperty skinProps = C.validUrl(skin) ? SkinsRestorerAPI.getApi().genSkinUrl(skin, skinVariant) : (IProperty)plugin.getMojangAPI().getSkin(skin).orElse(null);
                if (skinProps == null) {
                    sender.sendMessage(Locale.PREFIX + "\u00a74no skin found....");
                    return;
                }
                plugin.getSkinStorage().setSkinData(skinName, skinProps);
                for (ISRPlayer player : plugin.getOnlinePlayers()) {
                    String pName = player.getName();
                    plugin.getSkinStorage().setSkinOfPlayer(pName, skinName);
                    SkinsRestorerAPI.getApi().applySkin(player.getWrapper(), skinProps);
                }
                sender.sendMessage("\u00a7aSuccessfully set skin of all online players to " + skin);
            }
            catch (SkinRequestException e) {
                sender.sendMessage(e.getMessage());
            }
        });
    }

    default public void onPurgeOldData(ISRCommandSender sender, int days) {
        ISRPlugin plugin = this.getPlugin();
        plugin.runAsync(() -> {
            if (!sender.isConsole()) {
                sender.sendMessage(Locale.PREFIX + "\u00a74Only console may execute this command!");
                return;
            }
            if (plugin.getSkinStorage().purgeOldSkins(days)) {
                sender.sendMessage(Locale.PREFIX + "\u00a7aSuccessfully purged old skins!");
            } else {
                sender.sendMessage(Locale.PREFIX + "\u00a74A error occurred while purging old skins!");
            }
        });
    }

    public String getPlatformVersion();

    public String getProxyMode();

    public ISRPlugin getPlugin();

    public List<IProperty> getPropertiesOfPlayer(ISRPlayer var1);

    public static enum PlayerOrSkin {
        PLAYER,
        SKIN;

    }

    public static enum SkinType {
        STEVE,
        SLIM;

    }
}

